<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMenuLinksTable extends Migration {

	public function up()
	{
		Schema::create('menu_links', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name')->unique();
			$table->string('title');
			$table->string('link');
			$table->integer('menu_parent_id')->unsigned();
			$table->text('description');
			$table->boolean('status');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('menu_links');
	}
}