<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateYeucauTable extends Migration {

	public function up()
	{
		Schema::create('yeucau', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('ma_congviec_id')->unsigned()->nullable();
			$table->string('ten_kh');
			$table->string('sdt_kh');
			$table->integer('bophan_xuly_id')->unsigned()->nullable();
			$table->integer('nhanvien_xuly_id')->unsigned()->nullable();
			$table->integer('trangthai_chitiet_id')->unsigned()->nullable();
			$table->text('noidung');
			$table->integer('chinhanh_xuly_id')->unsigned()->nullable();
			$table->datetime('thoigian_dukien');
			$table->string('bienso');
			$table->integer('user_id')->unsigned()->nullable();
			$table->string('danhsach_phongban_xuly');
			$table->integer('trangthai_coban');
			$table->boolean('is_auto')->nullable()->default(0);
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('yeucau');
	}
}