<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMealsTable extends Migration {

	public function up()
	{
		Schema::create('meals', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->float('price');
			$table->tinyInteger('menu')->unsigned()->index();
			$table->string('title')->index();
			$table->string('description');
			$table->tinyInteger('calories')->unsigned();
			$table->tinyInteger('carbohydrates')->unsigned();
			$table->tinyInteger('protein')->unsigned();
			$table->tinyInteger('fat')->unsigned();
			$table->string('allergens');
			$table->integer('thumbnail_id')->unsigned();
			$table->integer('image_id')->unsigned();
			$table->tinyInteger('status')->unsigned()->index();
		});
	}

	public function down()
	{
		Schema::drop('meals');
	}
}