<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Meal extends Eloquent {

	protected $table = 'meals';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('menu', 'title', 'description', 'calories', 'carbohydrates', 'protein', 'fat', 'allergens', 'status');

	public function inOrders()
	{
		return $this->belongsTo('OrderMeal');
	}

	public function image()
	{
		return $this->hasOne('Image');
	}

	public function thumbnail()
	{
		return $this->hasOne('Image');
	}

}