<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 100)->nullable()->default('null');
			$table->string('email', 200)->unique();
			$table->string('password', 500);
			$table->string('department', 150)->nullable();
			$table->string('title', 250)->nullable();
			$table->integer('role_id');
			$table->enum('status', array('0', '1', '2'));
			$table->enum('gender', array('male', 'female'));
			$table->string('phone', 20)->nullable();
			$table->string('address', 500)->nullable();
			$table->datetime('joining_date');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}