<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Vault extends Eloquent {

	protected $table = 'vaults';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function websites()
	{
		return $this->hasMany('App\Models\VaultWebsite', 'vault_id', 'id');
	}

	public function settings()
	{
		return $this->hasOne('App\Models\VaultSetting', 'vault_id', 'id');
	}

}