<?php

namespace App\Models\Project;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Project extends Eloquent {

	protected $table = 'projects';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function satatus()
	{
		return $this->belongsToMany('App\Models\Status');
	}

	public function files()
	{
		return $this->morphMany('App\Models\File', 'model');
	}

}