<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCommentsTable extends Migration {

	public function up()
	{
		Schema::create('comments', function(Blueprint $table) {
			$table->increments('id');
			$table->text('content');
			$table->string('comment_id')->nullable();
			$table->string('lft');
			$table->string('rgt');
			$table->string('depth');
			$table->enum('status', array('0', '1', '2'));
			$table->string('model_type');
			$table->string('model_id');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('comments');
	}
}