<?php

namespace App\Modules\Blog\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Comment extends Eloquent {

	protected $table = 'blog_comments';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $guarded = array('id');

	public function post()
	{
		return $this->belongsTo('Post', 'post_id');
	}

}