<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Product extends Model 
{

    protected $table = 'Product';
    public $timestamps = false;

    public function price()
    {
        return $this->hasOne('Price');
    }

    public function provider()
    {
        return $this->belongsTo('Provider');
    }

    public function children()
    {
        return $this->hasMany('Product', 'parent_id', 'id');
    }

    public function parent()
    {
        return $this->belongsTo('Product', 'parent_id', 'id');
    }

}