<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductsIdentifiersTable extends Migration {

	public function up()
	{
		Schema::create('products_identifiers', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 255);
			$table->integer('product_abstraction_id')->unsigned();
			$table->integer('product_identifier_type_id')->unsigned();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('products_identifiers');
	}
}