<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAppointmentsGrossPayTable extends Migration {

	public function up()
	{
		Schema::create('appointments_gross_pay', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('appointment_id')->unsigned();
			$table->integer('financial_period_id')->unsigned();
			$table->decimal('gross_pay', 8,2);
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('appointments_gross_pay');
	}
}