<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAppointmentsTable extends Migration {

	public function up()
	{
		Schema::create('appointments', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->date('date_from');
			$table->date('date_to')->nullable();
			$table->decimal('hours_per_week', 8,2);
			$table->date('date_continuous_employment');
			$table->integer('position_id')->unsigned();
			$table->integer('person_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('appointments');
	}
}