<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateInvoiceTable extends Migration {

	public function up()
	{
		Schema::create('invoice', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 255);
			$table->text('description');
			$table->integer('currency_id')->unsigned();
			$table->integer('customer_id')->unsigned();
			$table->integer('supplier_id')->unsigned();
			$table->integer('settlement_days');
			$table->boolean('settlement_days_is_eom');
			$table->date('date_ledger');
			$table->date('date_tax_point');
			$table->decimal('net_total_currency', 8,2);
			$table->decimal('vat_total_currency', 8,2);
			$table->decimal('gross_total_currency', 8,2);
			$table->decimal('net_total', 8,2);
			$table->decimal('vat_total', 8,2);
			$table->decimal('gross_total', 8,2);
			$table->timestamps();
			$table->softDeletes();
			$table->integer('financial_period_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('invoice');
	}
}