<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateLinesTable extends Migration {

	public function up()
	{
		Schema::create('lines', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 255);
			$table->text('description');
			$table->integer('currency_id')->unsigned();
			$table->integer('lineable_id');
			$table->string('lineable_type', 255);
			$table->integer('listing_id')->unsigned();
			$table->integer('product_abstraction_id')->unsigned();
			$table->string('product_unique_stockbook_number', 255)->nullable();
			$table->decimal('quantity_of_product', 8,4)->nullable();
			$table->decimal('net_value_per_product', 8,4);
			$table->decimal('vat_value_per_product', 8,4);
			$table->decimal('gross_value_per_product', 8,4);
			$table->decimal('net_total', 8,2);
			$table->decimal('vat_total', 8,2);
			$table->decimal('gross_total', 8,2);
			$table->decimal('net_value_per_product_currency', 8,4);
			$table->decimal('vat_value_per_product_currency', 8,4);
			$table->decimal('gross_value_per_product_currency', 8,4);
			$table->decimal('net_total_currency', 8,2);
			$table->decimal('vat_total_currency', 8,2);
			$table->decimal('gross_total_currency', 8,4);
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('lines');
	}
}