<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrderTable extends Migration {

	public function up()
	{
		Schema::create('order', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('customer_id')->unsigned();
			$table->integer('supplier_id')->unsigned();
			$table->datetimeTz('datetime_accepted');
			$table->integer('accepted_by_person_id')->unsigned();
			$table->boolean('is_accepted');
			$table->boolean('is_cancelled');
			$table->datetimeTz('datetime_cancelled');
			$table->integer('cancelled_by_person_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('order');
	}
}