<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSettlementTable extends Migration {

	public function up()
	{
		Schema::create('settlement', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('bank_account_from_id')->unsigned();
			$table->integer('bank_account_to_id')->unsigned();
			$table->integer('currency_id')->unsigned();
			$table->integer('customer_id')->unsigned();
			$table->integer('supplier_id')->unsigned();
			$table->date('date_ledger');
			$table->datetimeTz('datetime_actual');
			$table->decimal('amount', 8,2);
			$table->decimal('amount_currency', 8,2);
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('settlement');
	}
}