<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateStockTable extends Migration {

	public function up()
	{
		Schema::create('stock', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('location_id')->unsigned();
			$table->decimal('quantity_available', 8,4);
			$table->integer('products_abstraction_id')->unsigned();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('stock');
	}
}