<?php

namespace App\Models\Finance;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class CostCode extends Eloquent {

	protected $table = 'cost_codes';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function invoices()
	{
		return $this->hasMany('App\Models\Finance\Invoice', 'cost_code_id');
	}

	public function projects()
	{
		return $this->hasMany('App\Models\Company\Project', 'cost_code_id');
	}

}