<?php

namespace App\Models\Company;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Location extends Eloquent {

	protected $table = 'locations';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function stock()
	{
		return $this->hasMany('App\Models\Stock\Stock', 'location_id');
	}

	public function parent()
	{
		return $this->belongsTo('App\Models\Company\Location', 'parent_id');
	}

	public function children()
	{
		return $this->hasMany('App\Models\Company\Location', 'parent_id');
	}

	public function positions()
	{
		return $this->hasMany('App\Models\HR\Position', 'location_id');
	}

}