<?php

namespace App\Models\Product;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class ProductAllowedAttribute extends Eloquent {

	protected $table = 'products_allowed_attributes';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function product_abstraction()
	{
		return $this->belongsTo('App\Models\Product\ProductAbstraction', 'product_abstraction_id');
	}

	public function product_attribute()
	{
		return $this->belongsTo('App\Models\Product\ProductAttribute', 'product_attribute_id');
	}

}