<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateArticlesTable extends Migration {

	public function up()
	{
		Schema::create('articles', function(Blueprint $table) {
			$table->integer('id')->unique()->unsigned();
			$table->text('title')->nullable();
			$table->text('description')->nullable();
			$table->integer('timestamp');
			$table->string('url', 1000)->nullable();
			$table->integer('facebook_shares')->nullable();
			$table->integer('blog_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('articles');
	}
}