<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSearchTermsTable extends Migration {

	public function up()
	{
		Schema::create('search_terms', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('term');
			$table->string('weight')->nullable();
			$table->string('field');
			$table->string('type')->nullable();
			$table->integer('export_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('search_terms');
	}
}