<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTwittersTable extends Migration {

	public function up()
	{
		Schema::create('twitters', function(Blueprint $table) {
			$table->integer('id')->unique()->unsigned();
			$table->string('url', 1000)->nullable();
			$table->string('name', 1000)->nullable();
			$table->string('screen_name', 1000)->nullable();
			$table->text('bio')->nullable();
			$table->integer('followers')->nullable();
			$table->float('engagement_rate', 40,20)->nullable();
			$table->float('average_retweets', 40,20)->nullable();
			$table->float('average_favorites', 40,20)->nullable();
			$table->integer('influencer_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('twitters');
	}
}