<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateYoutubeVideosTable extends Migration {

	public function up()
	{
		Schema::create('youtube_videos', function(Blueprint $table) {
			$table->integer('id')->unique()->unsigned();
			$table->string('name', 1000)->nullable();
			$table->text('description')->nullable();
			$table->string('link', 1000);
			$table->integer('timestamp');
			$table->integer('views')->nullable();
			$table->integer('comments')->nullable();
			$table->integer('likes')->nullable();
			$table->integer('dislikes')->nullable();
			$table->string('post_id', 500);
			$table->integer('youtube_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('youtube_videos');
	}
}