<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('ticket', function(Blueprint $table) {
			$table->foreign('dept_id')->references('id')->on('Department')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('ticket', function(Blueprint $table) {
			$table->foreign('team_id')->references('id')->on('Team')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('ticket', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('User')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('ticket', function(Blueprint $table) {
			$table->foreign('status_id')->references('id')->on('Status')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('ticket', function(Blueprint $table) {
			$table->foreign('project_id')->references('id')->on('Project')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Project', function(Blueprint $table) {
			$table->foreign('dept_id')->references('id')->on('Department')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Project', function(Blueprint $table) {
			$table->foreign('team_id')->references('id')->on('Team')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Department', function(Blueprint $table) {
			$table->foreign('org_id')->references('id')->on('Organization')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Team', function(Blueprint $table) {
			$table->foreign('dept_id')->references('id')->on('Department')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Team', function(Blueprint $table) {
			$table->foreign('team_lead_id')->references('id')->on('User')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Team', function(Blueprint $table) {
			$table->foreign('users_id')->references('id')->on('User')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Topic', function(Blueprint $table) {
			$table->foreign('project_id')->references('id')->on('Project')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Comment', function(Blueprint $table) {
			$table->foreign('ticket_id')->references('id')->on('ticket')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Comment', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('User')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('ticket', function(Blueprint $table) {
			$table->dropForeign('ticket_dept_id_foreign');
		});
		Schema::table('ticket', function(Blueprint $table) {
			$table->dropForeign('ticket_team_id_foreign');
		});
		Schema::table('ticket', function(Blueprint $table) {
			$table->dropForeign('ticket_user_id_foreign');
		});
		Schema::table('ticket', function(Blueprint $table) {
			$table->dropForeign('ticket_status_id_foreign');
		});
		Schema::table('ticket', function(Blueprint $table) {
			$table->dropForeign('ticket_project_id_foreign');
		});
		Schema::table('Project', function(Blueprint $table) {
			$table->dropForeign('Project_dept_id_foreign');
		});
		Schema::table('Project', function(Blueprint $table) {
			$table->dropForeign('Project_team_id_foreign');
		});
		Schema::table('Department', function(Blueprint $table) {
			$table->dropForeign('Department_org_id_foreign');
		});
		Schema::table('Team', function(Blueprint $table) {
			$table->dropForeign('Team_dept_id_foreign');
		});
		Schema::table('Team', function(Blueprint $table) {
			$table->dropForeign('Team_team_lead_id_foreign');
		});
		Schema::table('Team', function(Blueprint $table) {
			$table->dropForeign('Team_users_id_foreign');
		});
		Schema::table('Topic', function(Blueprint $table) {
			$table->dropForeign('Topic_project_id_foreign');
		});
		Schema::table('Comment', function(Blueprint $table) {
			$table->dropForeign('Comment_ticket_id_foreign');
		});
		Schema::table('Comment', function(Blueprint $table) {
			$table->dropForeign('Comment_user_id_foreign');
		});
	}
}