<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Reservation extends Eloquent {

	protected $table = 'reservations';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function book()
	{
		return $this->hasOne('Book');
	}

	public function order()
	{
		return $this->hasOne('Order');
	}

}