<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateChatsTable extends Migration {

	public function up()
	{
		Schema::create('chats', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->bigInteger('project_id')->unsigned();
			$table->bigInteger('user_id')->unsigned();
			$table->bigInteger('partner_id')->unsigned();
			$table->json('chats')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('chats');
	}
}