<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateNotificationsTable extends Migration {

	public function up()
	{
		Schema::create('notifications', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('user_id');
			$table->integer('read')->default('0');
			$table->string('title', 255);
			$table->string('description', 255);
			$table->string('icon', 255);
			$table->string('target', 255);
		});
	}

	public function down()
	{
		Schema::drop('notifications');
	}
}