<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Bid extends Eloquent {

	protected $table = 'bids';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function user()
	{
		return $this->belongsTo('App\User', 'user_id');
	}

	public function project()
	{
		return $this->belongsTo('App\Project', 'project_id');
	}

}