<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('provider_id', 255)->nullable();
			$table->string('provider_name', 255)->nullable();
			$table->integer('role_id');
			$table->integer('type_id')->nullable();
			$table->string('name', 255);
			$table->string('email')->unique();
			$table->timestamp('email_verified_at')->nullable();
			$table->string('password', 255);
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}