<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Question extends Model 
{

    protected $table = 'question';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('title', 'image', 'published');

    public function Answer()
    {
        return $this->hasMany('Answer');
    }

    public function Quiz()
    {
        return $this->belongsTo('Quiz');
    }

}