<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('question', function(Blueprint $table) {
			$table->foreign('quiz_id')->references('id')->on('quiz')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('answer', function(Blueprint $table) {
			$table->foreign('question_id')->references('id')->on('question')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_answers', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_answers', function(Blueprint $table) {
			$table->foreign('answer_id')->references('id')->on('answer')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_vark_results', function(Blueprint $table) {
			$table->foreign('quiz_id')->references('id')->on('quiz')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_vark_results', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_review', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_review', function(Blueprint $table) {
			$table->foreign('tutor_id')->references('id')->on('tutors')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('messages', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('messages', function(Blueprint $table) {
			$table->foreign('tutor_id')->references('id')->on('tutors')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('question', function(Blueprint $table) {
			$table->dropForeign('question_quiz_id_foreign');
		});
		Schema::table('answer', function(Blueprint $table) {
			$table->dropForeign('answer_question_id_foreign');
		});
		Schema::table('user_answers', function(Blueprint $table) {
			$table->dropForeign('user_answers_user_id_foreign');
		});
		Schema::table('user_answers', function(Blueprint $table) {
			$table->dropForeign('user_answers_answer_id_foreign');
		});
		Schema::table('user_vark_results', function(Blueprint $table) {
			$table->dropForeign('user_vark_results_quiz_id_foreign');
		});
		Schema::table('user_vark_results', function(Blueprint $table) {
			$table->dropForeign('user_vark_results_user_id_foreign');
		});
		Schema::table('user_review', function(Blueprint $table) {
			$table->dropForeign('user_review_user_id_foreign');
		});
		Schema::table('user_review', function(Blueprint $table) {
			$table->dropForeign('user_review_tutor_id_foreign');
		});
		Schema::table('messages', function(Blueprint $table) {
			$table->dropForeign('messages_user_id_foreign');
		});
		Schema::table('messages', function(Blueprint $table) {
			$table->dropForeign('messages_tutor_id_foreign');
		});
	}
}