<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateFeaturesTable extends Migration {

	public function up()
	{
		Schema::create('features', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('title', 255);
			$table->longText('body');
			$table->string('lable', 255);
			$table->string('value', 255);
			$table->bigInteger('product_id')->unsigned();
			$table->string('image', 255);
			$table->enum('type', array('features', 'specification'));
		});
	}

	public function down()
	{
		Schema::drop('features');
	}
}