<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRatesTable extends Migration {

	public function up()
	{
		Schema::create('rates', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('personal_name', 255);
			$table->bigInteger('client_id')->nullable();
			$table->double('rate', 255);
			$table->string('title', 255);
			$table->longText('description');
			$table->string('type', 255);
		});
	}

	public function down()
	{
		Schema::drop('rates');
	}
}