<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAddressesTable extends Migration {

	public function up()
	{
		Schema::create('addresses', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('country_name', 255);
			$table->string('governrate_name', 255);
			$table->string('city_name', 255);
			$table->longText('address');
			$table->bigInteger('user_id')->nullable();
			$table->longText('notes')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('addresses');
	}
}