<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAccountingNaturesTable extends Migration {

	public function up()
	{
		Schema::create('accounting_natures', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name');
			$table->smallInteger('status')->unsigned()->index()->default('1');
			$table->smallInteger('is_system')->unsigned()->index()->default('0');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('accounting_natures');
	}
}