<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDocumentTypeIssuingServicesTable extends Migration {

	public function up()
	{
		Schema::create('document_type_issuing_services', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('serviceable_id');
			$table->string('serviceable_name');
			$table->smallInteger('status')->unsigned()->index()->default('1');
			$table->smallInteger('is_system')->unsigned()->index()->default('0');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('document_type_issuing_services');
	}
}