<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEconomicActivityClassificationsTable extends Migration {

	public function up()
	{
		Schema::create('economic_activity_classifications', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name');
			$table->string('description')->unique()->nullable();
			$table->smallInteger('status')->unsigned()->index()->default('1');
			$table->smallInteger('is_system')->unsigned()->index()->default('0');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('economic_activity_classifications');
	}
}