<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateItemSubtypesTable extends Migration {

	public function up()
	{
		Schema::create('item_subtypes', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name');
			$table->integer('fiscal_classification_id')->unsigned()->nullable();
			$table->smallInteger('status')->unsigned()->index()->default('1');
			$table->smallInteger('is_system')->unsigned()->index()->default('0');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('item_subtypes');
	}
}