<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePartyTaxSchemaItemsTable extends Migration {

	public function up()
	{
		Schema::create('party_tax_schema_items', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('party_tax_schema_id')->unsigned();
			$table->integer('tax_type_code_id')->unsigned();
			$table->integer('exemption_reason_code_id')->unsigned();
			$table->smallInteger('is_exempt')->unsigned()->index()->default('1');
			$table->smallInteger('status')->unsigned()->index()->default('1');
			$table->smallInteger('is_system')->unsigned()->index()->default('0');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('party_tax_schema_items');
	}
}