<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTaxCodeRatesTable extends Migration {

	public function up()
	{
		Schema::create('tax_code_rates', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('tax_type_code_id')->unsigned();
			$table->decimal('value')->default('0.0');
			$table->string('name');
			$table->decimal('deductible')->default('0.0');
			$table->datetime('start_at');
			$table->datetime('end_at');
			$table->smallInteger('status')->unsigned()->index()->default('1');
			$table->smallInteger('is_system')->unsigned()->index()->default('0');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('tax_code_rates');
	}
}