<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTaxSubClassesTable extends Migration {

	public function up()
	{
		Schema::create('tax_sub_classes', function(Blueprint $table) {
			$table->increments('id');
			$table->string('code', 5)->unique()->nullable();
			$table->string('name');
			$table->integer('tax_class_id')->unsigned();
			$table->string('edifact5305', 5)->unique()->nullable();
			$table->smallInteger('status')->unsigned()->index()->default('1');
			$table->smallInteger('is_system')->unsigned()->index()->default('0');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('tax_sub_classes');
	}
}