<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateExemptionReasonCodesTable extends Migration {

	public function up()
	{
		Schema::create('exemption_reason_codes', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name');
			$table->string('description')->unique()->nullable();
			$table->integer('tax_class_id')->unsigned();
			$table->text('remarks')->nullable();
			$table->datetime('start_at')->nullable();
			$table->datetime('end_at')->nullable();
			$table->smallInteger('status')->unsigned()->index()->default('1');
			$table->smallInteger('is_system')->unsigned()->index()->default('0');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('exemption_reason_codes');
	}
}