<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateQuotationTypesTable extends Migration {

	public function up()
	{
		Schema::create('quotation_types', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name')->unique();
			$table->string('description')->nullable();
			$table->integer('fiscal_document_type_id')->unsigned();
			$table->integer('notification_id');
			$table->integer('contact_type_id')->unsigned();
			$table->smallInteger('status')->unsigned()->index()->default('1');
			$table->smallInteger('is_system')->unsigned()->index()->default('0');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('quotation_types');
	}
}