<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRevenuesClassificationsTable extends Migration {

	public function up()
	{
		Schema::create('revenues_classifications', function(Blueprint $table) {
			$table->increments('id');
			$table->string('code')->unique();
			$table->string('name');
			$table->text('remarks')->nullable();
			$table->smallInteger('status')->unsigned()->index()->default('1');
			$table->smallInteger('is_system')->unsigned()->index()->default('0');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('revenues_classifications');
	}
}