<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSeriesTable extends Migration {

	public function up()
	{
		Schema::create('series', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name')->unique();
			$table->string('description')->nullable();
			$table->integer('start_number')->default('1');
			$table->integer('end_number')->default('999999');
			$table->date('start_at');
			$table->date('end_at');
			$table->smallInteger('status')->unsigned()->index()->default('1');
			$table->smallInteger('is_system')->unsigned()->index()->default('0');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('series');
	}
}