<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateWithholdingTaxTypesTable extends Migration {

	public function up()
	{
		Schema::create('withholding_tax_types', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name');
			$table->string('description')->nullable();
			$table->integer('country_id')->unsigned();
			$table->integer('beneficiary_entity_id');
			$table->integer('fiscal_witholding_tax_type_id')->unsigned();
			$table->smallInteger('base_includes_discount')->unsigned()->default('0');
			$table->smallInteger('status')->unsigned()->index()->default('1');
			$table->smallInteger('is_system')->unsigned()->index()->default('0');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('withholding_tax_types');
	}
}