<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateContactTypesTable extends Migration {

	public function up()
	{
		Schema::create('contact_types', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name');
			$table->string('description')->nullable();
			$table->smallInteger('is_main_contact_type')->unsigned()->index()->default('0');
			$table->smallInteger('status')->unsigned()->index()->default('1');
			$table->smallInteger('is_system')->unsigned()->index()->default('0');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('contact_types');
	}
}