<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('items', function(Blueprint $table) {
			$table->foreign('type_id')->references('id')->on('item_types')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('items', function(Blueprint $table) {
			$table->foreign('base_unit_id')->references('id')->on('units')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('items', function(Blueprint $table) {
			$table->foreign('assortment_id')->references('id')->on('brand_models')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('items', function(Blueprint $table) {
			$table->foreign('brand_id')->references('id')->on('brands')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('items', function(Blueprint $table) {
			$table->foreign('brand_model_id')->references('id')->on('brand_models')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('regions', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countries')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('regions', function(Blueprint $table) {
			$table->foreign('culture_id')->references('id')->on('cultures')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('regions', function(Blueprint $table) {
			$table->foreign('time_zone_id')->references('id')->on('time_zones')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('withholding_tax_types', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countries')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('withholding_tax_types', function(Blueprint $table) {
			$table->foreign('fiscal_witholding_tax_type_id')->references('id')->on('fiscal_witholding_tax_types')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('units', function(Blueprint $table) {
			$table->foreign('unit_dimension_id')->references('id')->on('unit_dimensions')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('unit_dimensions', function(Blueprint $table) {
			$table->foreign('base_unit_id')->references('id')->on('units')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('countries', function(Blueprint $table) {
			$table->foreign('culture_id')->references('id')->on('cultures')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('issuing_stations', function(Blueprint $table) {
			$table->foreign('issuing_service_id')->references('id')->on('issuing_services')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('item_files', function(Blueprint $table) {
			$table->foreign('item_id')->references('id')->on('items')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tax_regional_areas', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countries')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tax_regional_areas', function(Blueprint $table) {
			$table->foreign('region_id')->references('id')->on('regions')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tax_sub_classes', function(Blueprint $table) {
			$table->foreign('tax_class_id')->references('id')->on('tax_classes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('exemption_reason_codes', function(Blueprint $table) {
			$table->foreign('tax_class_id')->references('id')->on('tax_classes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('fiscal_document_types', function(Blueprint $table) {
			$table->foreign('fiscal_use_id')->references('id')->on('fiscal_uses')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tax_type_codes', function(Blueprint $table) {
			$table->foreign('base_value_id')->references('id')->on('tax_type_base_values')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tax_type_codes', function(Blueprint $table) {
			$table->foreign('tax_class_id')->references('id')->on('tax_classes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tax_type_codes', function(Blueprint $table) {
			$table->foreign('tax_sub_class_id')->references('id')->on('tax_sub_classes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tax_type_codes', function(Blueprint $table) {
			$table->foreign('tax_regional_area_id')->references('id')->on('tax_regional_areas')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('party_tax_schema_items', function(Blueprint $table) {
			$table->foreign('party_tax_schema_id')->references('id')->on('party_tax_schemas')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('party_tax_schema_items', function(Blueprint $table) {
			$table->foreign('tax_type_code_id')->references('id')->on('tax_type_codes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('party_tax_schema_items', function(Blueprint $table) {
			$table->foreign('exemption_reason_code_id')->references('id')->on('exemption_reason_codes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tax_code_rates', function(Blueprint $table) {
			$table->foreign('tax_type_code_id')->references('id')->on('tax_type_codes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('item_tax_schema_tax_type_codes', function(Blueprint $table) {
			$table->foreign('item_tax_schema_id')->references('id')->on('item_tax_schemas')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('item_tax_schema_tax_type_codes', function(Blueprint $table) {
			$table->foreign('tax_type_code_id')->references('id')->on('tax_type_codes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('brand_models', function(Blueprint $table) {
			$table->foreign('brand_id')->references('id')->on('brands')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('item_subtypes', function(Blueprint $table) {
			$table->foreign('fiscal_classification_id')->references('id')->on('fiscal_classifications')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('item_sales', function(Blueprint $table) {
			$table->foreign('unit_id')->references('id')->on('issuing_services')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('item_sales', function(Blueprint $table) {
			$table->foreign('revenue_classification_id')->references('id')->on('revenues_classifications')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('item_sales', function(Blueprint $table) {
			$table->foreign('item_tax_schema_id')->references('id')->on('item_tax_schemas')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('item_materials', function(Blueprint $table) {
			$table->foreign('item_subtype_id')->references('id')->on('item_subtypes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('withholding_tax_codes', function(Blueprint $table) {
			$table->foreign('withholding_tax_type_id')->references('id')->on('withholding_tax_types')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('withholding_tax_codes', function(Blueprint $table) {
			$table->foreign('amount_base_id')->references('id')->on('withholding_tax_base_values')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('withholding_tax_rates', function(Blueprint $table) {
			$table->foreign('withholding_tax_code_id')->references('id')->on('withholding_tax_codes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('party_withholding_tax_schema_items', function(Blueprint $table) {
			$table->foreign('party_withholding_tax_schema_id')->references('id')->on('party_withholding_tax_schemas')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('party_withholding_tax_schema_items', function(Blueprint $table) {
			$table->foreign('withholding_tax_code_id')->references('id')->on('withholding_tax_codes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('item_withholding_tax_schema_withholding_tax_code', function(Blueprint $table) {
			$table->foreign('item_withholding_tax_schema_id')->references('id')->on('item_withholding_tax_schemas')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('item_withholding_tax_schema_withholding_tax_code', function(Blueprint $table) {
			$table->foreign('withholding_tax_code_id')->references('id')->on('withholding_tax_codes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('account_types', function(Blueprint $table) {
			$table->foreign('account_type_id')->references('id')->on('account_types')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('accounts', function(Blueprint $table) {
			$table->foreign('account_type_id')->references('id')->on('account_types')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('accounts', function(Blueprint $table) {
			$table->foreign('default_item_tax_schema_id')->references('id')->on('item_tax_schemas')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('invoice_types', function(Blueprint $table) {
			$table->foreign('fiscal_document_type_id')->references('id')->on('fiscal_document_types')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('invoice_types', function(Blueprint $table) {
			$table->foreign('contact_type_id')->references('id')->on('contact_types')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('invoice_types', function(Blueprint $table) {
			$table->foreign('default_credit_memo_type_id')->references('timestamps')->on('memo_types')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('invoice_types', function(Blueprint $table) {
			$table->foreign('default_debit_memo_type_id')->references('timestamps')->on('memo_types')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('order_types', function(Blueprint $table) {
			$table->foreign('fiscal_document_type_id')->references('id')->on('fiscal_document_types')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('order_types', function(Blueprint $table) {
			$table->foreign('order_nature_id')->references('id')->on('order_natures')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('order_types', function(Blueprint $table) {
			$table->foreign('contact_type_id')->references('id')->on('contact_types')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('order_types', function(Blueprint $table) {
			$table->foreign('default_invoice_type_id')->references('id')->on('invoice_types')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('order_types', function(Blueprint $table) {
			$table->foreign('default_memo_type_id')->references('id')->on('memo_types')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('quotation_types', function(Blueprint $table) {
			$table->foreign('fiscal_document_type_id')->references('id')->on('fiscal_document_types')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('quotation_types', function(Blueprint $table) {
			$table->foreign('contact_type_id')->references('id')->on('contact_types')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('memo_types', function(Blueprint $table) {
			$table->foreign('fiscal_document_type_id')->references('id')->on('fiscal_document_types')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('memo_types', function(Blueprint $table) {
			$table->foreign('accounting_nature_id')->references('id')->on('accounting_natures')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('memo_types', function(Blueprint $table) {
			$table->foreign('contact_type_id')->references('id')->on('contact_types')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('document_type_series', function(Blueprint $table) {
			$table->foreign('serie_id')->references('id')->on('series')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('document_type_series', function(Blueprint $table) {
			$table->foreign('economic_activity_classification_id')->references('id')->on('economic_activity_classifications')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('itemables', function(Blueprint $table) {
			$table->foreign('item_id')->references('id')->on('items')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('items', function(Blueprint $table) {
			$table->dropForeign('items_type_id_foreign');
		});
		Schema::table('items', function(Blueprint $table) {
			$table->dropForeign('items_base_unit_id_foreign');
		});
		Schema::table('items', function(Blueprint $table) {
			$table->dropForeign('items_assortment_id_foreign');
		});
		Schema::table('items', function(Blueprint $table) {
			$table->dropForeign('items_brand_id_foreign');
		});
		Schema::table('items', function(Blueprint $table) {
			$table->dropForeign('items_brand_model_id_foreign');
		});
		Schema::table('regions', function(Blueprint $table) {
			$table->dropForeign('regions_country_id_foreign');
		});
		Schema::table('regions', function(Blueprint $table) {
			$table->dropForeign('regions_culture_id_foreign');
		});
		Schema::table('regions', function(Blueprint $table) {
			$table->dropForeign('regions_time_zone_id_foreign');
		});
		Schema::table('withholding_tax_types', function(Blueprint $table) {
			$table->dropForeign('withholding_tax_types_country_id_foreign');
		});
		Schema::table('withholding_tax_types', function(Blueprint $table) {
			$table->dropForeign('withholding_tax_types_fiscal_witholding_tax_type_id_foreign');
		});
		Schema::table('units', function(Blueprint $table) {
			$table->dropForeign('units_unit_dimension_id_foreign');
		});
		Schema::table('unit_dimensions', function(Blueprint $table) {
			$table->dropForeign('unit_dimensions_base_unit_id_foreign');
		});
		Schema::table('countries', function(Blueprint $table) {
			$table->dropForeign('countries_culture_id_foreign');
		});
		Schema::table('issuing_stations', function(Blueprint $table) {
			$table->dropForeign('issuing_stations_issuing_service_id_foreign');
		});
		Schema::table('item_files', function(Blueprint $table) {
			$table->dropForeign('item_files_item_id_foreign');
		});
		Schema::table('tax_regional_areas', function(Blueprint $table) {
			$table->dropForeign('tax_regional_areas_country_id_foreign');
		});
		Schema::table('tax_regional_areas', function(Blueprint $table) {
			$table->dropForeign('tax_regional_areas_region_id_foreign');
		});
		Schema::table('tax_sub_classes', function(Blueprint $table) {
			$table->dropForeign('tax_sub_classes_tax_class_id_foreign');
		});
		Schema::table('exemption_reason_codes', function(Blueprint $table) {
			$table->dropForeign('exemption_reason_codes_tax_class_id_foreign');
		});
		Schema::table('fiscal_document_types', function(Blueprint $table) {
			$table->dropForeign('fiscal_document_types_fiscal_use_id_foreign');
		});
		Schema::table('tax_type_codes', function(Blueprint $table) {
			$table->dropForeign('tax_type_codes_base_value_id_foreign');
		});
		Schema::table('tax_type_codes', function(Blueprint $table) {
			$table->dropForeign('tax_type_codes_tax_class_id_foreign');
		});
		Schema::table('tax_type_codes', function(Blueprint $table) {
			$table->dropForeign('tax_type_codes_tax_sub_class_id_foreign');
		});
		Schema::table('tax_type_codes', function(Blueprint $table) {
			$table->dropForeign('tax_type_codes_tax_regional_area_id_foreign');
		});
		Schema::table('party_tax_schema_items', function(Blueprint $table) {
			$table->dropForeign('party_tax_schema_items_party_tax_schema_id_foreign');
		});
		Schema::table('party_tax_schema_items', function(Blueprint $table) {
			$table->dropForeign('party_tax_schema_items_tax_type_code_id_foreign');
		});
		Schema::table('party_tax_schema_items', function(Blueprint $table) {
			$table->dropForeign('party_tax_schema_items_exemption_reason_code_id_foreign');
		});
		Schema::table('tax_code_rates', function(Blueprint $table) {
			$table->dropForeign('tax_code_rates_tax_type_code_id_foreign');
		});
		Schema::table('item_tax_schema_tax_type_codes', function(Blueprint $table) {
			$table->dropForeign('item_tax_schema_tax_type_codes_item_tax_schema_id_foreign');
		});
		Schema::table('item_tax_schema_tax_type_codes', function(Blueprint $table) {
			$table->dropForeign('item_tax_schema_tax_type_codes_tax_type_code_id_foreign');
		});
		Schema::table('brand_models', function(Blueprint $table) {
			$table->dropForeign('brand_models_brand_id_foreign');
		});
		Schema::table('item_subtypes', function(Blueprint $table) {
			$table->dropForeign('item_subtypes_fiscal_classification_id_foreign');
		});
		Schema::table('item_sales', function(Blueprint $table) {
			$table->dropForeign('item_sales_unit_id_foreign');
		});
		Schema::table('item_sales', function(Blueprint $table) {
			$table->dropForeign('item_sales_revenue_classification_id_foreign');
		});
		Schema::table('item_sales', function(Blueprint $table) {
			$table->dropForeign('item_sales_item_tax_schema_id_foreign');
		});
		Schema::table('item_materials', function(Blueprint $table) {
			$table->dropForeign('item_materials_item_subtype_id_foreign');
		});
		Schema::table('withholding_tax_codes', function(Blueprint $table) {
			$table->dropForeign('withholding_tax_codes_withholding_tax_type_id_foreign');
		});
		Schema::table('withholding_tax_codes', function(Blueprint $table) {
			$table->dropForeign('withholding_tax_codes_amount_base_id_foreign');
		});
		Schema::table('withholding_tax_rates', function(Blueprint $table) {
			$table->dropForeign('withholding_tax_rates_withholding_tax_code_id_foreign');
		});
		Schema::table('party_withholding_tax_schema_items', function(Blueprint $table) {
			$table->dropForeign('party_withholding_tax_schema_items_party_withholding_tax_schema_id_foreign');
		});
		Schema::table('party_withholding_tax_schema_items', function(Blueprint $table) {
			$table->dropForeign('party_withholding_tax_schema_items_withholding_tax_code_id_foreign');
		});
		Schema::table('item_withholding_tax_schema_withholding_tax_code', function(Blueprint $table) {
			$table->dropForeign('item_withholding_tax_schema_withholding_tax_code_item_withholding_tax_schema_id_foreign');
		});
		Schema::table('item_withholding_tax_schema_withholding_tax_code', function(Blueprint $table) {
			$table->dropForeign('item_withholding_tax_schema_withholding_tax_code_withholding_tax_code_id_foreign');
		});
		Schema::table('account_types', function(Blueprint $table) {
			$table->dropForeign('account_types_account_type_id_foreign');
		});
		Schema::table('accounts', function(Blueprint $table) {
			$table->dropForeign('accounts_account_type_id_foreign');
		});
		Schema::table('accounts', function(Blueprint $table) {
			$table->dropForeign('accounts_default_item_tax_schema_id_foreign');
		});
		Schema::table('invoice_types', function(Blueprint $table) {
			$table->dropForeign('invoice_types_fiscal_document_type_id_foreign');
		});
		Schema::table('invoice_types', function(Blueprint $table) {
			$table->dropForeign('invoice_types_contact_type_id_foreign');
		});
		Schema::table('invoice_types', function(Blueprint $table) {
			$table->dropForeign('invoice_types_default_credit_memo_type_id_foreign');
		});
		Schema::table('invoice_types', function(Blueprint $table) {
			$table->dropForeign('invoice_types_default_debit_memo_type_id_foreign');
		});
		Schema::table('order_types', function(Blueprint $table) {
			$table->dropForeign('order_types_fiscal_document_type_id_foreign');
		});
		Schema::table('order_types', function(Blueprint $table) {
			$table->dropForeign('order_types_order_nature_id_foreign');
		});
		Schema::table('order_types', function(Blueprint $table) {
			$table->dropForeign('order_types_contact_type_id_foreign');
		});
		Schema::table('order_types', function(Blueprint $table) {
			$table->dropForeign('order_types_default_invoice_type_id_foreign');
		});
		Schema::table('order_types', function(Blueprint $table) {
			$table->dropForeign('order_types_default_memo_type_id_foreign');
		});
		Schema::table('quotation_types', function(Blueprint $table) {
			$table->dropForeign('quotation_types_fiscal_document_type_id_foreign');
		});
		Schema::table('quotation_types', function(Blueprint $table) {
			$table->dropForeign('quotation_types_contact_type_id_foreign');
		});
		Schema::table('memo_types', function(Blueprint $table) {
			$table->dropForeign('memo_types_fiscal_document_type_id_foreign');
		});
		Schema::table('memo_types', function(Blueprint $table) {
			$table->dropForeign('memo_types_accounting_nature_id_foreign');
		});
		Schema::table('memo_types', function(Blueprint $table) {
			$table->dropForeign('memo_types_contact_type_id_foreign');
		});
		Schema::table('document_type_series', function(Blueprint $table) {
			$table->dropForeign('document_type_series_serie_id_foreign');
		});
		Schema::table('document_type_series', function(Blueprint $table) {
			$table->dropForeign('document_type_series_economic_activity_classification_id_foreign');
		});
		Schema::table('itemables', function(Blueprint $table) {
			$table->dropForeign('itemables_item_id_foreign');
		});
	}
}